; Lotus Notes 5.0 Help Application scripts
;by A.G and D.B
;Copyright 1999, Henter-Joyce, Inc.

globals
	string PrevObjName,
	int IgnoreNewText ; for the caretless Help Topic windows

include "HjConst.jsh"
include "hjGlobal.jsh"
include "NNotesWS.jsh"
include "NNotesWS.jsm"

globals
	int ignoreNewText


Void Function AutoFinishEvent ()
PcCursor ()
RestrictCursor (off)
EndFunction

Void Function SayAllStoppedEvent ()
var
	int iObjType,
	string sCurrentClass
let iObjType = GetObjectTypeCode ()
let sCurrentClass = GetWindowClass (GetCurrentWindow ())
; To read the text of the help topic
If ((sCurrentClass == wcText) || 
(iObjType == WT_EDIT)) then
	If (IsJawsCursor ()) then
		RestrictCursor (Off)
		PcCursor ()
		Return
	EndIf
EndIf
EndFunction

Void Function ReadHelpTopic ()
var
	int iObjType,
	handle hFocus,
	string sClass
let iObjType = GetObjectTypeCode ()
let hFocus = GetFocus ()
let sClass = GetWindowClass (GetFocus ())
If (sClass == wcText) || 
(iObjType == WT_EDIT) then
	InvisibleCursor ()
	MoveToWindow (hFocus)
	RestrictCursor (on)
	SayAll ()
	Return
EndIf
EndFunction

Void Function ActiveItemChangedEvent (handle curHwnd, int curObjectId, int curChildId, handle prevHwnd, int prevObjectId, int prevChildId)
var
	int iObjType,
	string sObjName,
	string sObjValue,
	string sCurHwndClass,
	string sContent
let iObjType = GetObjectTypeCode ()
let sObjName = GetObjectName ()
let sCurHwndClass = GetWindowClass (CurHwnd)
let sContent = GetObjectValue ()
;for Line views
If ((iObjType == WT_TREEVIEWITEM) ||
(iObjType == WT_TREEVIEW)) then
	SayTreeViewLevel ()
	Return
EndIf
If (sCurHwndClass == wcText) then
	If (CaretVisible ()) then
		;wn2 = "Write the body of the help document here."
		If (sObjName == wn2) &&
		(PrevChildId > 5000000) then
			Return
		EndIf
		SayObjectTypeAndText ()
		Return
	EndIf
	Say (sObjValue, OT_TEXT)
	Return
EndIf
SaveCursor ()
PCCursor ()
SayObjectActiveItem ()
RestoreCursor ()
EndFunction

Void Function ValueChangedEvent (handle hwnd, int objId, int childId, int nObjType, string sObjName, string sObjValue)
var
	string sCurrentClass
let sCurrentClass = GetWindowClass (GetCurrentWindow ())
If (nObjType == WT_HOTKEY) then
	If (! DialogActive ()) then
		If (sCurrentClass != wcTaskList) then
			Say (sObjValue, OT_MESSAGE)
			return
		EndIf
	EndIf
EndIf
EndFunction

Void Function FocusChangedEvent (handle focusWindow, handle prevWindow)
var
	int iObjType,
	string sBuffer,
	string sFocusClass,
string sPrevClass
let iObjType = GetObjectTypeCode ()
let sBuffer = GetWindowText (focusWindow, false)
let sFocusClass = GetWindowClass (FocusWindow)
let sPrevClass = GetWindowClass (prevWindow)
RestrictCursor (off)
;Stop overchatter when moving between apps using alt+tab in Windows 9X
;Removing this code block will result in an infinite loop of annoying speech
If (sFocusClass == wcTaskList) ||
((sPrevClass == wcTaskList) &&
(sFocusClass == wcText)) then
	return
EndIf
If (sFocusClass == wcText) then
	If (sPrevClass == wcTree) then
		If (! CaretVisible ()) then
			If (iObjType != WT_TREEVIEWITEM) then
				If (iObjType != WT_TREEVIEW) then
					Pause ()
					Refresh ()
					Return
				EndIf
			EndIf
		EndIf
	EndIf
EndIf
FocusChangedEvent (focusWindow, prevWindow)
EndFunction

Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes,
int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
; Handles all newly written text.  If the text is contained in a
; frame, then the frame name is passed as a parameter
var
	handle hFocus,
	string sFocusClass,
	string sHwndClass 
let hFocus = GetFocus ()
let sFocusClass = GetWindowClass (hFocus)
let sHwndClass = GetWindowClass (hWnd)
if (ProcessSelectText(nAttributes,buffer)) then
  return
endif
if (sFrameName == "") then
	; this text is not associated with a frame
	If (IgnoreNewText) then
		return
	EndIf
	; To read the text of the help topic
	If (GlobalMenuMode == 0) then
		If (! CaretVisible ()) then
			If (sHwndClass == wcText) then
				If (hFocus == hWnd) then
					Say (buffer, OT_BUFFER)
				EndIf
				Return
			EndIf
		EndIf
	EndIf
	if (nAttributes& ATTRIB_HIGHLIGHT) then 
		SayHighlightedText(hwnd,buffer)
	else 
		SayNonHighlightedText(hwnd,buffer) 
	endif
else
  ; this text is associated with a frame
  if (nEcho == ECHO_NONE) then 
		return 
	endif  ; frame is being silenced
	if (nEcho  == ECHO_ALL ||
	(nAttributes & ATTRIB_HIGHLIGHT)) then
		; if FrameEcho is set to all or the text being written is highlighted
		Say (buffer, ot_buffer)
	endif
endif
EndFunction

Void Function SayNonhighlightedText (handle hWnd, string buffer)
SayNonhighlightedText (hWnd, buffer)
EndFunction

Void Function SayFocusedWindow ()
var
	int iWinType,
	string sWinType,
	string sCurrentClass
let iWinType = GetWindowSubTypeCode (GlobalFocusWindow)
let sWinType = GetWindowType (GlobalFocusWindow)
let sCurrentClass = GetWindowClass (GetCurrentWindow ())
PcCursor ()
RestrictCursor (Off)
; to avoid extra chatter during Help Topic reading
If (sCurrentClass == wcText) then
	Return
EndIf
If (iWinType == WT_PASSWORDEDIT) then
	Say (msg29, OT_CONTROL_NAME) ; "Password: "
	Say (sWinType, OT_CONTROL_NAME)
	Say (GetWindowText (GlobalFocusWindow, false), OT_TEXT)
	Return
EndIf
SayFocusedObject ()
EndFunction

Void Function BrailleBuildLine ()
var
	handle hwnd,
	int iRow,
	int iCol,
	int ObjectTypeCode,
	int WindowTypeCode,
	string sObjName
if MenusActive () then
	if !GlobalPixelsPerSpace then
		let GlobalPixelsPerSpace=GetJcfOption (OPT_PIXELS_PER_SPACE)
	EndIf
	SetJcfOption (OPT_PIXELS_PER_SPACE, 99)
	BrailleBuildMenu()
	Return TRUE
EndIf
let hwnd = GetFocus()
let ObjectTypeCode = GetObjectTypeCode ()
let WindowTypeCode = GetWindowSubTypeCode (hwnd)
let iRow = GetCursorRow ()
let iCol = GetCursorCol ()
let sObjName = GetObjectName ()
if DialogActive () then
	if !GlobalPixelsPerSpace then
		let GlobalPixelsPerSpace=GetJcfOption (OPT_PIXELS_PER_SPACE)
	EndIf
	SetJcfOption (OPT_PIXELS_PER_SPACE, 99)
	BrailleBuildDialog(GetRealWindow(hwnd))
	return TRUE
EndIf
If (ObjectTypeCode == WT_EDIT) then
	If (sObjName == wn3) then
		BrailleAddString (msg28, 0,0,0)
		BrailleAddFocusLine ()
		Return true
	EndIf
	Return true
EndIf
if WindowTypeCode == WT_LISTVIEW ||
ObjectTypeCode == WT_LISTVIEW ||
WindowTypeCode == WT_LISTBOX ||
ObjectTypeCode == WT_LISTBOX ||
WindowTypeCode == WT_TREEVIEW ||
ObjectTypeCode == WT_TREEVIEW ||
ObjectTypeCode == WT_TREEVIEWITEM ||
WindowTypeCode == WT_STARTBUTTON ||
ObjectTypeCode == WT_STARTBUTTON ||
WindowTypeCode == WT_DESKTOP ||
ObjectTypeCode == WT_DESKTOP ||
WindowTypeCode == WT_TASKBAR ||
ObjectTypeCode == WT_TASKBAR
then
	if !GlobalPixelsPerSpace then
		let GlobalPixelsPerSpace=GetJcfOption (OPT_PIXELS_PER_SPACE)
	EndIf
	SetJcfOption (OPT_PIXELS_PER_SPACE, 99)
	If (GetJcfOption (OPT_MSAA_MODE) == 2) then
		BrailleBuildOther (ObjectTypeCode)
		Return
	EndIf
	BrailleBuildOther(WindowTypeCode)
	Return TRUE
EndIf
if GlobalPixelsPerSpace then
	SetJcfOption (OPT_PIXELS_PER_SPACE, GlobalPixelsPerSpace)
EndIf
let GlobalPixelsPerSpace = 0
return FALSE
EndFunction

Void Function ScreenSensitiveHelpForKnownClasses (int nObjType)
If ((nObjType == WT_TREEVIEWITEM) ||
(nObjType == WT_TREEVIEW)) then
	Say (msg4, ot_help) ;"Line view level "
	SayInteger (GetTreeViewLevel ())
	Say (msg5, ot_help) ;"use up or down arrow to read through the items"
	Say (msg6, ot_help) ;"or press the first letter to jump through the list"
	Say (msg7, ot_help) ;"use the right or left arrow keys to open or close an item or"
	Say (msg8 + GetScriptKeyName ("ExpandAll"), ot_help) ;"To expand all items in the tree, use"
	Say (msg9 + GetScriptKeyName ("CollapseAll"), ot_help) ;"To collapse all items in the tree, use"
	Return
EndIf
If (nObjType == WT_TASKBAR) then
	Say (msg19, OT_HELP); "You are experiencing minor focus problems"
Say (msg20, OT_HELP); "Press f6 twice to return to your window and give it focus"
	Return
EndIf
ScreenSensitiveHelpForKnownClasses (nObjType)
EndFunction

Script ScriptFileName ()
ScriptAndAppNames ("Lotus 5 help")
EndScript

Script SayWindowPromptAndText ()
var
	int iObjType,
	int iWinType,
	handle hWnd,
	string sClass
let iObjType = GetObjectTypeCode ()
let iWinType = GetWindowSubTypeCode (GetCurrentWindow ())
let hWnd = GetCurrentWindow ()
let sClass = GetWindowClass (hWnd)
If (iWinType == WT_PASSWORDEDIT) then
	Say (msg29, OT_CONTROL_NAME) ; "Password: "
	Say (GetWindowType (GetCurrentWindow ()), OT_CONTROL_NAME)
	Say (GetWindowText (GetCurrentWindow (), false), OT_TEXT)
	Return
EndIf
If ((iObjType == WT_TREEVIEW) ||
(iObjType == WT_TREEVIEWITEM)) then
	SayFocusedObject ()
	Say (msg1, OT_CONTROL_NAME); "level"
	SayInteger (GetTreeViewLevel ())
	Return
EndIf
SayFocusedObject ()
EndScript

Script ScreenSensitiveHelp ()
var
	int TheObjType
let TheObjType = GetObjectTypeCode ()
If (IsSameScript ()) then
	AppFileTopic ()
	return
EndIf
If (GlobalMenuMode > 0) then
	PerformScript ScreenSensitiveHelp ()
	Return
EndIf
If (TheObjType == WT_TREEVIEW) ||
(TheObjType == WT_TREEVIEWITEM) then
		ScreenSensitiveHelpForKnownClasses (TheObjType)
	Return
EndIf
; for the Help Topic windows
If (TheObjType == WT_EDIT) then
	If (! CaretVisible ()) then
		Say (msg13, OT_HELP); "This is the Help Topic window"
		Say (msg14, OT_HELP); "You are currently not in Edit Mode, which means you can activate links within the topic"
		Say (msg15, OT_HELP); "Use the left and right arrow keys to select a link and press the space bar to activate"
		Say (msg16 + GetScriptKeyName ("HotKeyHelp"), OT_HELP); "For Jaws Hot keys for this window, press"
		Return
	EndIf
	Say (msg17, OT_HELP); "The Help Topic window is active"
	Say (msg18, OT_HELP); "Edit mode is on"
	ScreenSensitiveHelpForKnownClasses (TheObjType)
	Return;
EndIf
PerformScript ScreenSensitiveHelp ()
EndScript

Script HotKeyHelp ()
var
	handle hWnd,
	string sClass
let hWnd = GetCurrentWindow ()
let sClass = GetWindowClass (GetCurrentWindow ())
SayExtendedHelpHotKey ()
If (DialogActive ()) then
	HotKeyHelpDefaultLoop ()
	Return
EndIf
Say (msg24 + GetScriptKeyName ("WindowKeysHelp"), OT_HELP); "To hear a list of Windows Shortcut keys, press"
Say (msg25 + GetScriptKeyName ("NextFrame"), OT_HELP); "To switch between the Contents Line view and the Help Topic document, press"
If (sClass == wcText) then
	If (! CaretVisible ()) then
		Say (msg21 + GetScriptKeyName ("ReadCurrentScreen"), ot_help); "To read the current screen with the Jaws Cursor, press"
		Say (msg22 + GetScriptKeyName ("ReadNextScreen"), OT_HELP); "To read the next screen with the Jaws cursor, press"
		Say (msg23 + GetScriptKeyName ("ReadPriorScreen"), OT_HELP); "To read the prior screen with the Jaws cursor, press"
		Return
	EndIf
EndIf
EndScript

Script WindowKeysHelp ()
Say (msg26, OT_HELP); "Press and hold the alt key down to hear a list of available Lotus shortcut keys"
Say (msg27, OT_HELP); "When you hear the option you want, continue to hold the alt key down and press the number or letter that corresponds with your option"
EndScript

Script SayPriorCharacter ()
var
	int iObjType,
	string sObjValue
If (GlobalMenuMode > 0) then
	PerformScript SayPriorCharacter ()
	Return
EndIf
If (! IsPcCursor ()) then
	PerformScript SayPriorCharacter ()
	Return
EndIf
let iObjType = GetObjectTypeCode ()
If (iObjType == WT_TREEVIEW) ||
(iObjType == WT_TREEVIEWITEM) then
	{NumPadMinus}
	Return
EndIf
If (! CaretVisible ()) then
	{LeftArrow}
	Pause ()
	let sObjValue = GetObjectValue ()
	Say (sObjValue, OT_CONTROL_NAME)
	Return
EndIf
PerformScript SayPriorCharacter ()
EndScript

Script SayNextCharacter ()
var
	int iObjType,
	string sObjValue
let iObjType = GetObjectTypeCode ()
If (GlobalMenuMode > 0) then
	PerformScript SayNextCharacter ()
	Return
EndIf
If (! IsPcCursor ()) then
	PerformScript SayNextCharacter ()
	return
EndIf
If (iObjType == WT_TREEVIEW) ||
(iObjType == WT_TREEVIEWITEM) then
	{NumPadPlus}
	Return
EndIf
If (! CaretVisible ()) then
	{RightArrow}
	Pause ()
	let sObjValue = GetObjectValue ()
	Say (sObjValue, OT_CONTROL_NAME)
	Return
EndIf
PerformScript SayNextCharacter ()
EndScript

Script JawsBackspace ()
var
	int iObjType
If (GlobalMenuMode > 0) then
	return
EndIf
If (! IsPcCursor ()) then
	Return
EndIf
let iObjType = GetObjectTypeCode ()
If (iObjType == WT_TREEVIEW) ||
(iObjType == WT_TREEVIEW) then
	{NumPadMinus}
	Return
EndIf
PerformScript JawsBackspace ()
EndScript

Script ExpandAll ()
	{shift+NumPadPlus}
Say (msg2, OT_MESSAGE); "expand all"
EndScript

Script CollapseAll ()
{shift+NumPadMinus}
Say (msg3, OT_MESSAGE); "collapse all"
EndScript

Script ReadCurrentScreen ()
var
	int iObjType,
	handle hFocus,
	string sCurrentClass
let iObjType = GetObjectTypeCode ()
let hFocus = GetFocus ()
let sCurrentClass = GetWindowClass (GetCurrentWindow ())
If (sCurrentClass == wcText) ||
(iObjType == WT_EDIT) then
	JawsCursor ()
	MoveToWindow (hFocus)
	RestrictCursor (on)
	JawsCursor ()
	SayAll ()
	RestrictCursor (off)
	Return
Else
	Say (msg10, OT_MESSAGE); 
EndIf
EndScript

Script ReadNextScreen ()
RestrictCursor (off)
let IgnoreNewText = true
{PageDown}
Pause ()
PerformScript ReadCurrentScreen ()
let ignoreNewText = false
EndScript

Script ReadPriorScreen ()
RestrictCursor (off)
let IgnoreNewText = true
{PageUp}
Pause ()
PerformScript ReadCurrentScreen ()
let ignoreNewText = false
EndScript

Script UpALevel ()
RestrictCursor (off)
PcCursor ()
PerformScript UpALevel ()
EndScript

Script SayLine ()
var
	int iWinType,
	string sObjName,
	string sClass
If (! IsPcCursor ()) then
	PerformScript SayLine ()
	Return
EndIf
If (GlobalMenuMode > 0) then
	PerformScript SayLine ()
	Return
EndIf
let iWinType = GetWindowSubTypeCode (GetFocus ())
let sObjName = GetObjectName ()
let sClass = GetWindowClass (GetFocus ())
If (sClass == wcText) then
	If (CaretVisible ()) then
		SaveCursor ()
		RouteInvisibleToPc ()
		InvisibleCursor ()
		RestrictCursor (on)
		SayLine ()
		RestrictCursor (off)
		RestoreCursor ()
		Return
	EndIf
EndIf
If (IsPcCursor ()) then
	If (iWinType == WT_PASSWORDEDIT) then
		Say (msg29, OT_CONTROL_NAME) ; "Password: "
		Say (GetWindowType (GetFocus ()), OT_CONTROL_NAME)
		Say (GetWindowText (GetFocus (), false), OT_TEXT)
		Return
	EndIf
EndIf
PerformScript SayLine ()
EndScript

Script SayNextLine ()
var
	string sObjName,
	string sClass
let sObjName = GetObjectName ()
let sClass = GetWindowClass (GetFocus ())
If (IsPcCursor ()) then
	If (GlobalMenuMode == 0) then
		If(CaretVisible ()) then
			If (sClass == wcText) then
;wn2 = "Write the body of the help document here."
				If (sObjName == wn2) then
					{DownArrow}
					If ((IsLeftButtonDown ()) ||
					(IsRightButtonDown ())) then
						SelectingText (true)
						Pause ()
						SelectingText (false)
					EndIf
					SaveCursor ()
					RouteInvisibleToPc ()
					InvisibleCursor ()
					RestrictCursor (on)
					SayLine ()
					RestrictCursor (off)
					RestoreCursor ()
					Return
				EndIf
			EndIf
		EndIf
	EndIf
EndIf
PerformScript SayNextLine ()
EndScript

Script SayPriorLine ()
var
	string sObjName,
	string sClass
let sObjName = GetObjectName ()
let sClass = GetWindowClass (GetFocus ())
If (IsPcCursor ()) then
	If (GlobalMenuMode == 0) then
		If (CaretVisible ()) then
			If (sClass == wcText) then
				;wn2 = "Write the body of the help document here."
				If (sObjName == wn2) then
					{UpArrow}
					If ((IsLeftButtonDown ()) ||
					(IsRightButtonDown ())) then
						SelectingText (true)
						Pause ()
						SelectingText (false)
					EndIf
					SaveCursor ()
					RouteInvisibleToPc ()
					InvisibleCursor ()
					RestrictCursor (on)
					SayLine ()
					RestrictCursor (off)
					RestoreCursor ()
					Return
				EndIf
			EndIf
		EndIf
	EndIf
EndIf
PerformScript SayPriorLine ()
EndScript

Script NextFrame ()
{f6}
Pause ()
EndScript

Script PriorFrame ()
{shift+f6}
Pause ()
EndScript
